package gov.va.med.mhv.common.api.transfer;

import java.io.Serializable;

public class ClientApplication implements Serializable {
	private static final long serialVersionUID = 1826098372825277393L;
	
	private Long id;
	private String name;
	private String appToken;
	private String[] permissions;
	private Integer timeoutSeconds;
	private String[] authorizations;
	private Boolean internal;
	private Boolean uriPathCheck;
	
	public ClientApplication() {
	}
	
	public ClientApplication(Long id, String name, String appToken, String permissions[], String autorizations[], Integer timeoutSeconds, Boolean internal, Boolean uriPathCheck){
		this.id=id;
		this.name = name;
		this.appToken = appToken;
		this.permissions = permissions;
		this.authorizations = autorizations;
		this.timeoutSeconds = timeoutSeconds;
		this.internal = internal;
		this.uriPathCheck = uriPathCheck;
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getAppToken() {
		return appToken;
	}
	public void setAppToken(String appToken) {
		this.appToken = appToken;
	}
	public String[] getPermissions() {
		return permissions;
	}
	public void setPermissions(String[] permissions) {
		this.permissions = permissions;
	}
	public String[] getAuthorizations() {
		return authorizations;
	}

	public void setAuthorizations(String[] authorizations) {
		this.authorizations = authorizations;
	}

	public Integer getTimeoutSeconds() {
		return timeoutSeconds;
	}
	public void setTimeoutSeconds(Integer timeoutSeconds) {
		this.timeoutSeconds = timeoutSeconds;
	}
	
	public Boolean getInternal() {
		return internal;
	}

	public void setInternal(Boolean internal) {
		this.internal = internal;
	}

	public Boolean getUriPathCheck() {
		return uriPathCheck;
	}

	public void setUriPathCheck(Boolean uriPathCheck) {
		this.uriPathCheck = uriPathCheck;
	}

	public String toString() {
		StringBuffer str = new StringBuffer();
		for( String p: permissions ) {
			str.append(p).append(',');
		}
		return "ClientApplication { name=" + name + "; appToken=" +appToken+"; permissions="+str.substring(0, str.length()-1)+"; timeout="+timeoutSeconds+" }";
	}
	
	public boolean isInternal() {
		return internal;
	}
}
